using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

public partial class FileTestForm1 : Form
{
    public FileTestForm1()
    {
        InitializeComponent();
    }

    private void openFileDialog1_FileOk(object sender, CancelEventArgs e)
    {
        string fileName = openFileDialog1.FileName;

        if (File.Exists(fileName))
        {
            displayFileInfo(fileName);
        }
    }

    private void displayFileInfo(string fileName)
    {
        outputTextBox.Text += "\r\n\r\nFile: " + fileName + ":\r\n";
        DateTime creationTime = File.GetCreationTime(fileName);
        outputTextBox.Text += "Created: " + creationTime.ToString() + "\r\n";
        DateTime lastModifiedTime = File.GetLastAccessTime(fileName);
        outputTextBox.Text += "Last accessed: " + lastModifiedTime.ToString() + "\r\n";
    }

    private void displayDirectoryInfo(string pathName)
    {
        string[] directoryList;
        directoryList = Directory.GetDirectories(pathName);
        outputTextBox.Text += "\r\n\r\nDirectory Contents:\r\n";

        // Output directory contents
        for (int i = 0; i < directoryList.Length; i++)
            outputTextBox.Text += directoryList[i] + "\r\n";
    }

    private void button1_Click(object sender, EventArgs e)
    {
        openFileDialog1.ShowDialog();
    }

    private void button2_Click(object sender, EventArgs e)
    {
        folderBrowserDialog1.ShowDialog();
        string pathName = folderBrowserDialog1.SelectedPath;
        if (Directory.Exists(pathName))
        {
            displayDirectoryInfo(pathName);           
        }

    }

}

 